/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.mapui;

import filenet.sim.toolkit.viewer.VWSIMAnimatorMap;
import filenet.sim.toolkit.viewer.VWSIMAnimatorRoute;
import filenet.sim.toolkit.viewer.VWSIMAnimatorStep;
import filenet.sim.toolkit.viewer.mapui.IVWSIMAnimatorStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorCallStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorComponentStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorGeneralStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorLaunchStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorMapWrapper;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorRouteUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorSystemStepUI;
import filenet.sim.toolkit.viewer.mapui.VWSIMAnimatorWorkflowPane;
import filenet.sim.toolkit.viewer.mapui.resources.VWSIMResource;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.mapui.IVWSelectWorkflowItem;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapNodeUIToolkit;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWSIMAnimatorWorkflowMapPane
extends VWBaseWorkflowMapPane {
    private VWSIMAnimatorMap m_mapData = null;
    private Frame m_parentFrame = null;
    private VWPropertyChangeEvent m_propertyChangeEvent = null;
    private VWMapNodeUIToolkit m_mapNodeUIToolkit = null;
    protected Vector m_changeListeners = new Vector();
    private JPopupMenu m_popup = null;
    private Hashtable m_stepDataToUI = null;
    private Hashtable m_routeDataToUI = null;

    public VWSIMAnimatorWorkflowMapPane(VWSIMAnimatorWorkflowPane workflowPane) {
        super(workflowPane);
        if (workflowPane != null) {
            this.m_parentFrame = workflowPane.getParentFrame();
            this.m_mapNodeUIToolkit = new VWMapNodeUIToolkit(workflowPane.getSessionInfo().getExternalClassLoader(), workflowPane.getMapAttributes());
        }
    }

    public void setMapDefinition(VWMap map) {
        this.m_steps = new Vector();
        this.m_routes = new Vector();
        if (map != null && map instanceof VWSIMAnimatorMapWrapper) {
            this.m_map = map;
            this.m_mapData = ((VWSIMAnimatorMapWrapper)map).getAnimatorMap();
            if (this.m_mapData == null) {
                VWDebug.logWarning(VWSIMResource.s_nullWorkflowDefinition);
            } else {
                Vector stepCollection;
                VWStepRouteColors stepRouteColors = null;
                if (this.m_workflowPane != null && this.m_workflowPane instanceof VWSIMAnimatorWorkflowPane) {
                    stepRouteColors = ((VWSIMAnimatorWorkflowPane)this.m_workflowPane).getStepRouteColors();
                }
                if ((stepCollection = this.m_mapData.getSteps()) != null) {
                    int index;
                    int top = 0;
                    Vector routeCollection = this.m_mapData.getRoutes();
                    this.m_stepDataToUI = new Hashtable(stepCollection.size());
                    this.m_routeDataToUI = new Hashtable(routeCollection.size());
                    for (index = 0; index < stepCollection.size(); ++index) {
                        VWBaseStepUI step = null;
                        VWSIMAnimatorStep stepData = (VWSIMAnimatorStep)stepCollection.elementAt(index);
                        VWMapNode mapNode = stepData.getMapNode();
                        if (stepData.isLaunchStep()) {
                            step = new VWSIMAnimatorLaunchStepUI(this.m_parentFrame, stepData, this.m_mapNodeUIToolkit);
                        } else if (stepData.isQueueStep() || stepData.isUserStep() || stepData.isDummyStep()) {
                            step = new VWSIMAnimatorGeneralStepUI(this.m_parentFrame, stepData, stepData.isStartStep(), this.m_mapNodeUIToolkit);
                        } else if (stepData.isCallStep()) {
                            step = new VWSIMAnimatorCallStepUI(this.m_parentFrame, stepData, stepData.isStartStep(), this.m_mapNodeUIToolkit);
                        } else if (stepData.isSystemStep()) {
                            step = new VWSIMAnimatorSystemStepUI(this.m_parentFrame, stepData, stepData.isStartStep(), this.m_mapNodeUIToolkit);
                        } else if (stepData.isComponentStep()) {
                            step = new VWSIMAnimatorComponentStepUI(this.m_parentFrame, stepData, stepData.isStartStep(), this.m_mapNodeUIToolkit);
                        }
                        this.m_steps.addElement(step);
                        this.m_stepDataToUI.put(stepData, step);
                        step.addFocusListener(this);
                        Rectangle bounds = step.getBounds();
                        if (top <= bounds.y) continue;
                        top = bounds.y;
                    }
                    if (top < 0) {
                        Object obj = null;
                        VWSIMAnimatorStepUI step = null;
                        VWBaseStepUI baseStep = null;
                        for (index = 0; index < this.m_steps.size(); ++index) {
                            obj = this.m_steps.elementAt(index);
                            if (obj == null || !(obj instanceof IVWSIMAnimatorStepUI) || (step = ((IVWSIMAnimatorStepUI)obj).getAnimatorStepUI()) == null || (baseStep = step.getBaseStepUI()) == null) continue;
                            Point p = baseStep.getLocation();
                            p.y -= top;
                            baseStep.setLocation(p);
                        }
                    }
                    for (index = 0; index < routeCollection.size(); ++index) {
                        VWSIMAnimatorRouteUI route = null;
                        VWBaseStepUI prevStep = null;
                        VWBaseStepUI nextStep = null;
                        VWSIMAnimatorStep step = null;
                        VWSIMAnimatorRoute routeData = (VWSIMAnimatorRoute)routeCollection.elementAt(index);
                        step = routeData.getPreviousStep();
                        if (step != null) {
                            prevStep = (VWBaseStepUI)this.m_stepDataToUI.get(step);
                        }
                        if ((step = routeData.getNextStep()) != null) {
                            nextStep = (VWBaseStepUI)this.m_stepDataToUI.get(step);
                        }
                        if (nextStep == null || (route = nextStep.hasARouteToStep(prevStep) ? new VWSIMAnimatorRouteUI(routeData, prevStep, nextStep, false, 2, stepRouteColors, this.m_workflowPane.getMapAttributes()) : new VWSIMAnimatorRouteUI(routeData, prevStep, nextStep, false, 1, stepRouteColors, this.m_workflowPane.getMapAttributes())) == null) continue;
                        route.addFocusListener(this);
                        prevStep.addNextRoute(route, nextStep);
                        nextStep.addPrevRoute(route, prevStep);
                        this.repaint(((VWBaseRouteUI)route).getBounds());
                        this.m_routes.addElement(route);
                        this.m_routeDataToUI.put(routeData, route);
                    }
                } else {
                    VWDebug.logError(VWSIMResource.s_noStepsOnMap);
                }
            }
            this.recalculateBounds(0);
            this.repaint();
        }
    }

    protected VWSIMAnimatorRouteUI findRoute(int routeId) {
        for (int index = 0; index < this.m_routes.size(); ++index) {
            VWSIMAnimatorRouteUI route = (VWSIMAnimatorRouteUI)this.m_routes.elementAt(index);
            if (route.getId() != routeId) continue;
            return route;
        }
        return null;
    }

    protected VWSIMAnimatorRouteUI findRoute(VWSIMAnimatorRoute route) {
        return (VWSIMAnimatorRouteUI)this.m_routeDataToUI.get(route);
    }

    public VWBaseRouteUI findRoute(VWRouteDefinition routeDefinition) {
        return super.findRoute(routeDefinition);
    }

    protected IVWSIMAnimatorStepUI findStep(int stepId) {
        Object obj = null;
        for (int index = 0; index < this.m_steps.size(); ++index) {
            IVWSIMAnimatorStepUI step;
            obj = this.m_steps.elementAt(index);
            if (!(obj instanceof IVWSIMAnimatorStepUI) || (step = (IVWSIMAnimatorStepUI)obj).getId() != stepId) continue;
            return step;
        }
        return null;
    }

    public VWBaseStepUI findStep(VWMapNode mapNode) {
        return super.findStep(mapNode);
    }

    public IVWSIMAnimatorStepUI findStep(VWSIMAnimatorStep step) {
        try {
            if (step == null) {
                System.out.println("findStep(step) - step is null");
                return null;
            }
            if (this.m_stepDataToUI == null) {
                System.out.println("findStep(step) - m_stepDataToUI is null");
                return null;
            }
            return (IVWSIMAnimatorStepUI)this.m_stepDataToUI.get(step);
        }
        catch (Exception ex) {
            System.out.println("findStep(VWSIMAnimatorStep step) throws exception - m_stepDataToUI is not null, step is not null");
            VWDebug.logException(ex);
            return null;
        }
    }

    public void selectSteps(int[] stepIds) {
        if (stepIds != null && stepIds.length > 0) {
            IVWSIMAnimatorStepUI step = null;
            this.clearAllSelectedItems(false);
            for (int i = 0; i < stepIds.length; ++i) {
                step = this.findStep(stepIds[i]);
                if (step == null || !(step instanceof VWBaseStepUI)) continue;
                if (i == 0) {
                    ((VWBaseStepUI)((Object)step)).setFocus(true);
                }
                ((VWBaseStepUI)((Object)step)).setSelect(true);
            }
            this.notifySelectListeners(true);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable itemSelectable = e.getItemSelectable();
        Object[] objects = itemSelectable.getSelectedObjects();
        boolean bSelect = e.getStateChange() == 1;
    }

    public VWSIMAnimatorMap getMapData() {
        return this.m_mapData;
    }

    public int getMapId() {
        if (this.m_map != null) {
            return this.m_map.getMapId();
        }
        return -1;
    }

    public String[] getParentMapNames() {
        Vector parentMaps;
        String[] parentMapNames = null;
        if (this.m_mapData != null && (parentMaps = this.m_mapData.getParentMaps()) != null && parentMaps.size() > 0) {
            parentMapNames = new String[parentMaps.size()];
            for (int i = 0; i < parentMaps.size(); ++i) {
                Object obj = parentMaps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMap)) continue;
                parentMapNames[i] = ((VWSIMAnimatorMap)obj).getMapName();
            }
            Object var2_2 = null;
        }
        return parentMapNames;
    }

    public void stateChanged(ChangeEvent e) {
        this.notifyChangeListeners();
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.m_changeListeners.addElement(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.m_changeListeners.removeElement(l);
    }

    protected void notifyChangeListeners() {
        for (int i = 0; i < this.m_changeListeners.size(); ++i) {
            ((ChangeListener)this.m_changeListeners.elementAt(i)).stateChanged(new ChangeEvent(this));
        }
    }

    public void mouseClicked(MouseEvent evt) {
        VWSIMAnimatorMap submap;
        Point pt;
        IVWSelectWorkflowItem item;
        this.requestFocus();
        super.mouseClicked(evt);
        if (evt.isPopupTrigger()) {
            this.createPopup(evt);
        }
        if (evt.getClickCount() == 2 && (item = this.getItemAtLocation(pt = evt.getPoint())) instanceof VWSIMAnimatorCallStepUI && ((VWSIMAnimatorCallStepUI)item).getStepData() != null && (submap = ((VWSIMAnimatorCallStepUI)item).getStepData().getSubmap()) != null && this.m_workflowPane != null && this.m_workflowPane instanceof VWSIMAnimatorWorkflowPane) {
            ((VWSIMAnimatorWorkflowPane)this.m_workflowPane).notifyDisplayMap(submap);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        super.mouseReleased(evt);
        if (evt.isPopupTrigger()) {
            this.createPopup(evt);
        }
    }

    private void createPopup(MouseEvent evt) {
        Point pt;
        IVWSelectWorkflowItem item;
        Object source = evt.getSource();
        if (source instanceof VWSIMAnimatorWorkflowMapPane && (item = this.getItemAtLocation(pt = evt.getPoint())) instanceof IVWSIMAnimatorStepUI) {
            Vector selectedItems = this.getAllSelectedItems();
            if (selectedItems.size() > 1) {
                return;
            }
            IVWSIMAnimatorStepUI step = (IVWSIMAnimatorStepUI)((Object)item);
            step.createPopup(this, evt);
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj instanceof IVWPropertyChangeSource) {
            // empty if block
        }
    }

    public void removeReferences() {
        Object obj;
        int i;
        if (this.m_steps != null) {
            for (i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseStepUI)) continue;
                ((VWBaseStepUI)obj).removeFocusListener(this);
                ((VWBaseStepUI)obj).removeReferences();
            }
            this.m_steps.removeAllElements();
            this.m_steps = null;
        }
        if (this.m_routes != null) {
            for (i = 0; i < this.m_routes.size(); ++i) {
                obj = this.m_routes.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseRouteUI)) continue;
                ((VWBaseRouteUI)obj).removeFocusListener(this);
                ((VWBaseRouteUI)obj).removeReferences();
            }
            this.m_routes.removeAllElements();
            this.m_routes = null;
        }
        this.m_mapData = null;
        this.m_parentFrame = null;
        if (this.m_changeListeners != null) {
            this.m_changeListeners.removeAllElements();
            this.m_changeListeners = null;
        }
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            this.m_popup = null;
        }
        if (this.m_stepDataToUI != null) {
            this.m_stepDataToUI.clear();
            this.m_stepDataToUI = null;
        }
        if (this.m_routeDataToUI != null) {
            this.m_routeDataToUI.clear();
            this.m_routeDataToUI = null;
        }
        super.removeReferences();
        this.removeAll();
    }

    public void activated() {
        super.activated();
        if (this.m_propertyChangeEvent != null) {
            this.propertyChange(this.m_propertyChangeEvent);
            this.m_propertyChangeEvent = null;
        }
    }

    public void invalidRouteRegion(VWSIMAnimatorRouteUI route) {
        Rectangle rect = new Rectangle(route.getBounds());
        this.repaint(rect);
    }

    public void invalidRegion(VWSIMAnimatorStepUI step) {
        super.invalidStepRegion(step.getBaseStepUI());
    }

    public void invalidRegion(VWBaseStepUI step) {
        super.invalidStepRegion(step);
    }

    public void invalidateMap() {
        Rectangle rect = this.getBounds();
        this.repaint(rect);
    }
}

